/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.stateproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.registry.FOTBlockStateProviderTypes;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import org.jetbrains.annotations.Nullable;

public class DirectionalRandomizedIntBooleanStateProvider
extends BlockStateProvider {
    public static final MapCodec<DirectionalRandomizedIntBooleanStateProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("source").forGetter(provider -> provider.source), (App)Codec.STRING.fieldOf("integer_property").forGetter(provider -> provider.integerPropertyName), (App)IntProvider.CODEC.fieldOf("integer_values").forGetter(provider -> provider.integerValues), (App)Codec.STRING.fieldOf("direction_property").forGetter(provider -> provider.directionPropertyName), (App)Codec.STRING.fieldOf("boolean_property").forGetter(provider -> provider.booleanPropertyName), (App)ConstantFloat.CODEC.fieldOf("boolean_chance").forGetter(provider -> provider.booleanChance)).apply((Applicative)instance, DirectionalRandomizedIntBooleanStateProvider::new));
    private final BlockStateProvider source;
    private final String integerPropertyName;
    @Nullable
    private IntegerProperty integerProperty;
    private final IntProvider integerValues;
    private final String directionPropertyName;
    @Nullable
    private DirectionProperty directionProperty;
    private final String booleanPropertyName;
    @Nullable
    private BooleanProperty booleanProperty;
    private final ConstantFloat booleanChance;

    public DirectionalRandomizedIntBooleanStateProvider(BlockStateProvider source, IntegerProperty integerProperty, IntProvider integerValues, DirectionProperty directionProperty, BooleanProperty booleanProperty, ConstantFloat booleanChance) {
        this.source = source;
        this.integerProperty = integerProperty;
        this.integerPropertyName = integerProperty.getName();
        this.integerValues = integerValues;
        this.directionProperty = directionProperty;
        this.directionPropertyName = directionProperty.getName();
        this.booleanProperty = booleanProperty;
        this.booleanPropertyName = booleanProperty.getName();
        this.booleanChance = booleanChance;
        Collection collection = integerProperty.getPossibleValues();
        for (int i = integerValues.getMinValue(); i <= integerValues.getMaxValue(); ++i) {
            if (collection.contains(i)) continue;
            throw new IllegalArgumentException("Property value out of range: " + integerProperty.getName() + ": " + i);
        }
    }

    public DirectionalRandomizedIntBooleanStateProvider(BlockStateProvider source, String integerPropertyName, IntProvider integerValues, String directionPropertyName, String booleanPropertyName, ConstantFloat booleanChance) {
        this.source = source;
        this.integerPropertyName = integerPropertyName;
        this.integerValues = integerValues;
        this.directionPropertyName = directionPropertyName;
        this.booleanPropertyName = booleanPropertyName;
        this.booleanChance = booleanChance;
    }

    protected BlockStateProviderType<?> type() {
        return FOTBlockStateProviderTypes.DIRECTIONAL_RANDOMIZED_INT_BOOLEAN_STATE_PROVIDER;
    }

    public BlockState getState(RandomSource random, BlockPos pos) {
        throw new UnsupportedOperationException();
    }

    public BlockState getState(RandomSource random, BlockPos pos, Direction direction) {
        BlockState blockState = this.source.getState(random, pos);
        if (this.integerProperty == null || !blockState.hasProperty((Property)this.integerProperty)) {
            this.integerProperty = DirectionalRandomizedIntBooleanStateProvider.findProperty(blockState, this.integerPropertyName, IntegerProperty.class);
        }
        if (this.directionProperty == null || !blockState.hasProperty((Property)this.directionProperty)) {
            this.directionProperty = DirectionalRandomizedIntBooleanStateProvider.findProperty(blockState, this.directionPropertyName, DirectionProperty.class);
        }
        if (this.booleanProperty == null || !blockState.hasProperty((Property)this.booleanProperty)) {
            this.booleanProperty = DirectionalRandomizedIntBooleanStateProvider.findProperty(blockState, this.booleanPropertyName, BooleanProperty.class);
        }
        return (BlockState)((BlockState)((BlockState)blockState.setValue((Property)this.integerProperty, (Comparable)Integer.valueOf(this.integerValues.sample(random)))).setValue((Property)this.directionProperty, (Comparable)direction)).setValue((Property)this.booleanProperty, (Comparable)Boolean.valueOf(random.nextFloat() < this.booleanChance.getValue()));
    }

    private static <T extends Property<?>> T findProperty(BlockState state, String propertyName, Class<T> propertyClass) {
        Collection collection = state.getProperties();
        Optional<Property> optional = collection.stream().filter(property -> property.getName().equals(propertyName)).filter(propertyClass::isInstance).map(propertyClass::cast).findAny();
        return (T)optional.orElseThrow(() -> new IllegalArgumentException("Illegal property: " + propertyName));
    }
}

